<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        // 'App\\Events\\Event' => [
        //     'App\\Listeners\\EventListener',
        // ],

        \App\Events\TransactionPaymentAdded::class => [
            \App\Listeners\AddAccountTransaction::class,
            \App\Listeners\SendInAppActivityNotification::class,
        ],

        \App\Events\TransactionPaymentUpdated::class => [
            \App\Listeners\UpdateAccountTransaction::class,
            \App\Listeners\SendInAppActivityNotification::class,
        ],

        \App\Events\TransactionPaymentDeleted::class => [
            \App\Listeners\DeleteAccountTransaction::class,
            \App\Listeners\SendInAppActivityNotification::class,
        ],

        // In-app notifications for core business events
        \App\Events\SellCreatedOrModified::class => [
            \App\Listeners\SendInAppActivityNotification::class,
        ],
        \App\Events\PurchaseCreatedOrModified::class => [
            \App\Listeners\SendInAppActivityNotification::class,
        ],
        \App\Events\StockTransferCreatedOrModified::class => [
            \App\Listeners\SendInAppActivityNotification::class,
        ],
    ];

    public function boot()
    {
        //
    }

    public function shouldDiscoverEvents()
    {
        return false;
    }
}
